<?php
// Import PHPMailer classes into the global namespace
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Load composer's autoloader
require 'vendor/autoload.php';

// Mail values
$fromName        = trim($_POST["fromName"]);
$fromEmail       = trim($_POST["fromEmail"]);
$replyToEmail    = trim($_POST["replyToEmail"]);
$toEmail         = trim($_POST["toEmail"]);
$subjectLine     = trim($_POST["subjectLine"]);

// Message Values
$richMessageText = $_POST["richMessageText"];
$message         = "";
$messageErrorSet = false;

// Attachment
$path            = "uploads/";
$path            = $path . basename($_FILES['attachment']['name']);
$fileTempName    = $_FILES['attachment']['tmp_name'];
$fileUploaded    = 0; // 0 = no upload, 1 = upload success, 2 = upload failure
$attatchError    = "";

// File attacher + error handler
if (!empty($fileTempName)) {
    // Attempt to upload file
    if (move_uploaded_file($fileTempName, $path)) {
        $fileUploaded = 1; // success
    } else {
        $fileUploaded = 2; // failure
        $attatchError = "Your message was not sent. There was an error uploading your attachment. Make sure that your php.ini file within your web server allows for file uploads, and that it allows for the upload size of your attached file. Check out <a href='https://mediatemple.net/community/products/dv/204403894/how-can-i-edit-the-php.ini-file'>this guide</a> to make changes to the php.ini file.";
    }
}

// Store the right message body as the $message var
if (!empty($richMessageText)) {
    $message = $richMessageText;
} else {
    $messageErrorText = "Your message was not sent. It appears as if you did not enter any content into the message text area. Make sure that you go back and input content here.";
    $messageErrorSet = true;
}

$mail = new PHPMailer(true); // Passing `true` enables exceptions
$sentCount = 0;
$failCount = 0;
try {
    // Recipients
    $mail->setFrom($fromEmail, $fromName);
    $mail->addReplyTo($replyToEmail);

    // Process each email in the "To" field
    $toAddresses = explode("\n", $toEmail);
    foreach ($toAddresses as $toAddress) {
        $mail->clearAddresses(); // Clear previous addresses
        $mail->addAddress(trim($toAddress));

        // Attachments
        if (!empty($fileTempName)) {
            $mail->addAttachment($path);
        }

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subjectLine;
        $mail->Body    = $message;

        // Send Mail using values
        if ($fileUploaded != 2) {
            if ($mail->send()) {
                $sentCount++;
            } else {
                $failCount++;
            }
        }
    }

    echo "
    <div class=\"col-md-6 offset-md-3\">
        <div class=\"alert alert-success\" role=\"alert\">
            <strong>Email Sent!</strong> Your spoofed email has been sent using the values seen below. 
            <br>Emails sent: $sentCount
            <br>Emails failed: $failCount
        </div>
    </div>
    ";

} catch (Exception $e) {
    echo "
    <div class=\"col-md-6 offset-md-3\">
        <div class=\"alert alert-danger\" role=\"alert\">
            <p><strong>Awe Snap! </strong>Your message was not sent. Something went wrong with the PHP mail() function and is returning a value of FALSE. Chances are if you are seeing this message it means that it could not reach out to the SMTP server. Make sure that the webserver you are running is configured to also point to a mail server.</p>
        </div>
    </div>
    ";
}

// SUCCESS AND ERROR MESSAGES

if ($messageErrorSet == true) {
    echo "
    <div class=\"col-md-6 offset-md-3\">
        <div class=\"alert alert-danger\" role=\"alert\">
            <p><strong>Awe Snap! </strong>".$messageErrorText."</p>
        </div>
    </div>
    ";
}

if ($fileUploaded == 2) {
    echo "
    <div class=\"col-md-6 offset-md-3\">
        <div class=\"alert alert-danger\" role=\"alert\">
            <p><strong>Awe Snap! </strong>" . $attatchError . "</p>
        </div>
    </div>
    ";
}
?>
