<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Load composer's autoloader
require 'vendor/autoload.php';

// Function to validate email
function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

// Function to sanitize input
function sanitizeInput($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// Mail values
$fromName = sanitizeInput($_POST["fromName"]);
$fromEmail = sanitizeInput($_POST["fromEmail"]);
$replyToEmail = sanitizeInput($_POST["replyToEmail"]);
$toEmail = sanitizeInput($_POST["toEmail"]);
$cc = sanitizeInput($_POST["cc"]);
$bcc = sanitizeInput($_POST["bcc"]);
$subjectLine = sanitizeInput($_POST["subjectLine"]);

// Message Values
$richMessageText = $_POST["richMessageText"];
$rawMessageText = $_POST["rawMessageText"];
$message = "";
$messageErrorSet = false;

// Attachment
$path = "uploads/";
$path = $path . basename($_FILES['attachment']['name']);
$fileTempName = $_FILES['attachment']['tmp_name'];
$fileUploaded = 0;
$attachError = "";

// File attacher + error handler
if (!empty($fileTempName)) {
    // Validate file type and size (example: 5MB limit)
    $allowedTypes = ['image/jpeg', 'image/png', 'application/pdf'];
    $maxFileSize = 5 * 1024 * 1024; // 5MB
    $fileType = mime_content_type($fileTempName);
    $fileSize = filesize($fileTempName);

    if (in_array($fileType, $allowedTypes) && $fileSize <= $maxFileSize) {
        if (move_uploaded_file($fileTempName, $path)) {
            $fileUploaded = 1; // success
        } else {
            $fileUploaded = 2; // failure
            $attachError = "Error uploading your attachment. Please check your server settings.";
        }
    } else {
        $fileUploaded = 2; // failure
        $attachError = "Invalid file type or size. Only JPEG, PNG, and PDF files under 5MB are allowed.";
    }
}

// Store the right message body as the $message var
if (!empty($richMessageText) && empty($rawMessageText)) {
    $message = $richMessageText;
} elseif (empty($richMessageText) && !empty($rawMessageText)) {
    $message = $rawMessageText;
} elseif (!empty($richMessageText) && !empty($rawMessageText)) {
    $messageErrorText = "Please use only one of the rich text or raw text editors.";
    $messageErrorSet = true;
} else {
    $messageErrorText = "No message content provided.";
    $messageErrorSet = true;
}

// Validate email addresses
if (!validateEmail($fromEmail) || !validateEmail($toEmail) || ($replyToEmail && !validateEmail($replyToEmail))) {
    $messageErrorText = "Invalid email address provided.";
    $messageErrorSet = true;
}

// Send email using PHPMailer
if (!$messageErrorSet && $fileUploaded != 2) {
    $mail = new PHPMailer(true);
    try {
        $mail->setFrom($fromEmail, $fromName);
        $mail->addAddress($toEmail);
        if ($replyToEmail) {
            $mail->addReplyTo($replyToEmail);
        }
        if (!empty($cc) && validateEmail($cc)) {
            $mail->addCC($cc);
        }
        if (!empty($bcc) && validateEmail($bcc)) {
            $mail->addBCC($bcc);
        }
        if ($fileUploaded == 1) {
            $mail->addAttachment($path);
        }
        $mail->isHTML(true);
        $mail->Subject = $subjectLine;
        $mail->Body = $message;
        $mail->send();
        echo '<div class="alert alert-success">Email Sent!</div>';
    } catch (Exception $e) {
        echo '<div class="alert alert-danger">Mailer Error: ' . $mail->ErrorInfo . '</div>';
    }
} else {
    echo '<div class="alert alert-danger">' . $messageErrorText . '</div>';
}

if ($fileUploaded == 2) {
    echo '<div class="alert alert-danger">' . $attachError . '</div>';
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>WebGeek | Review your email</title>
    <link rel="stylesheet" href="bootstrap-4.0.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="zaqar.css">
    <link rel="icon" href="favicon.ico">
</head>
<body class="p-5" style="background-image: url('img/bg.png');">
    <div class="col-md-6 offset-md-3">
        <div class="card">
            <div class="card-header">
                <h3>Review Your Message</h3>
            </div>
            <div class="card-body">
                <table class="table">
                    <tr>
                        <td>From: </td>
                        <td><?php echo "&#8220;" . $fromName . "&#8221;" . " &#60;" . $fromEmail . "&#62;" ?></td>
                    </tr>
                    <tr>
                        <td>To: </td>
                        <td><?php echo $toEmail ?></td>
                    </tr>
                    <tr>
                        <td>Reply To:</td>
                        <td><?php echo $replyToEmail ?></td>
                    </tr>
                    <?php if (!empty($cc)) { ?>
                    <tr>
                        <td>Cc: </td>
                        <td><?php echo $cc ?></td>
                    </tr>
                    <?php } ?>
                    <?php if (!empty($bcc)) { ?>
                    <tr>
                        <td>Bcc: </td>
                        <td><?php echo $bcc ?></td>
                    </tr>
                    <?php } ?>
                    <?php if ($fileUploaded == 1) { ?>
                    <tr>
                        <td>Attachment: </td>
                        <td><a href="<?php echo $path; ?>" target="_blank"><?php echo basename($_FILES['attachment']['name']); ?></a></td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td>Subject: </td>
                        <td><?php echo $subjectLine ?></td>
                    </tr>
                </table>
                <h4 class="lead">Message Body</h4>
                <div class="card p-2">
                    <?php echo !$messageErrorSet ? $message : "<strong style=\"color:red;\">INVALID</strong>"; ?>
                </div>
            </div>
        </div>
        <a href="index.html" class="btn btn-primary btn-lg mt-3" style="display: block; margin:auto;">Send another spoofed email</a>
    </div>
</body>
</html>
